/** @file   mediumwormalien.h
 * @brief   Declaration of MediumWormAlien - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_MEDIUMWORMALIEN_H
#define H_WWW_MEDIUMWORMALIEN_H

#include "smallwormalien.h"

namespace WeWantWar {


/** @class  MediumWormAlien
 * @brief   Another alien worm.
 * @author  Tomi Lamminsaari
 *
 */
class MediumWormAlien : public SmallWormAlien
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	MediumWormAlien();


	/** Destructor
   */
	virtual ~MediumWormAlien();

	/** Copy constructor.
   * @param     rO                Reference to another MediumWormAlien
   */
  MediumWormAlien( const MediumWormAlien& rO );

	/** Assignment operator
   * @param     rO                Reference to another MediumWormAlien
   * @return    Reference to us.
   */
  MediumWormAlien& operator = ( const MediumWormAlien& rO );



  ///
  /// Methods
  /// =======

  /** Reimplemented update
   */
  virtual void update();


  ///
  /// Getter methods
  /// ==============

  /** Returns the object type
   * @return    ObjectID::TYPE_MEDIUMWORMALIEN
   */
  virtual ObjectID::Type objectType() const;

protected:

  /** Reimplemented shooting method
   */
  virtual void attack();
  
  /** Reimplemented method for setting up the correct animation
   * @param     animID            ID of the animation we should setup
   */
  virtual void setCorrectAnimation( int animID );
  
  
  ///
  /// Members
  /// =======



private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif

/**
 * Version history
 * ===============
 * $Log: mediumwormalien.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:02+02  lamminsa
 * Initial revision
 *
 */
 
